/**
* \file: configuration.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AAM_CONTROL_CONFIGURATION_H
#define AAM_CONTROL_CONFIGURATION_H

#include <stdbool.h>
#include <bits/types.h>

#include "utils/logger.h"
#include "control/mount.h"

error_code_t configuration_init(int argc, char *argv[]);

void configuration_deinit(void);

error_code_t configuration_parse_configuration_file(void);

const char *configuration_get_proc_name(void);

bool configuration_shall_daemonize(void);

const char *configuration_get_automount_options(const char* file_system);

const char *configuration_get_media_dir(void);

bool configuration_mount_data_cdda_cds(void);

bool configuration_is_console_enabled(void);

logger_loglevel_t configuration_get_loglevel(void);

__mode_t configuration_get_mountpoint_mode(void);

int configuration_mp_ext_give_up_cnt(void);

__mode_t configuration_get_socket_dir_mode(void);

__mode_t configuration_get_socket_access_mode(void);

gid_t configuration_get_socket_group_id(void);


#endif
